<?php
require_once 'config.php';

// Esta consulta es compleja. Une todas las tablas necesarias
$sql = "SELECT 
            p.NombreComercial,
            t.fecha_traslado,
            t.estado,
            dt.cantidad_unidad,
            dt.cantidad_blister,
            dt.cantidad_caja,
            dt.sefactura, -- <-- NUEVA LÍNEA
            s_origen.nombre AS sucursal_origen,
            s_destino.nombre AS sucursal_destino,
            u_envia.nombre AS usuario_envia,
            u_recibe.nombre AS usuario_recibe
        FROM detalle_traslados AS dt
        JOIN traslados AS t ON dt.traslado_id = t.id
        JOIN productos AS p ON dt.producto_id = p.id
        JOIN sucursales AS s_origen ON t.sucursal_origen = s_origen.id
        JOIN sucursales AS s_destino ON t.sucursal_destino = s_destino.id
        JOIN usuarios AS u_envia ON t.usuario_id = u_envia.id
        LEFT JOIN usuarios AS u_recibe ON t.usuario_receptor_id = u_recibe.id
        WHERE t.sucursal_origen = ? OR t.sucursal_destino = ?
        ORDER BY t.fecha_traslado DESC
        LIMIT 20";

try {
    $stmt = $pdo->prepare($sql);
    // Mostramos traslados enviados O recibidos por la sucursal actual
    $stmt->execute([ID_SUCURSAL_ACTUAL, ID_SUCURSAL_ACTUAL]);
    $traslados = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($traslados) {
        $html = '';
        foreach ($traslados as $t) {
            
            // Determinar cantidad y presentación
            $cantidad = 0;
            $presentacion = 'N/A';
            if ($t['cantidad_caja'] > 0) {
                $cantidad = $t['cantidad_caja'];
                $presentacion = 'Caja';
            } elseif ($t['cantidad_blister'] > 0) {
                $cantidad = $t['cantidad_blister'];
                $presentacion = 'Blíster';
            } elseif ($t['cantidad_unidad'] > 0) {
                $cantidad = $t['cantidad_unidad'];
                $presentacion = 'Unidad';
            }
            
            $fecha = date('d/m/Y H:i A', strtotime($t['fecha_traslado']));
            $usuario_recibe = $t['usuario_recibe'] ? $t['usuario_recibe'] : 'N/A';
            
            // Estilo para el estado
            $clase_estado = 'bg-secondary';
            if ($t['estado'] == 'en_transito') $clase_estado = 'bg-warning text-dark';
            if ($t['estado'] == 'completado') $clase_estado = 'bg-success';
            if ($t['estado'] == 'cancelado') $clase_estado = 'bg-danger';

            // ================== NUEVA LÍNEA ==================
            // Convertimos el 1/0 de 'sefactura' en "SI" o "NO"
            $facturable_texto = $t['sefactura'] == 1 
                ? "<span class='badge bg-success'>SI</span>" 
                : "<span class='badge bg-secondary'>NO</span>";
            // ===============================================

            $html .= "<tr>";
            $html .= "<td>{$t['NombreComercial']}</td>";
            $html .= "<td>{$presentacion}</td>";
            $html .= "<td>{$cantidad}</td>";
            $html .= "<td>{$t['sucursal_origen']}</td>";
            $html .= "<td>{$t['sucursal_destino']}</td>";
            $html .= "<td>{$t['usuario_envia']}</td>";
            $html .= "<td>{$usuario_recibe}</td>";
            $html .= "<td>{$facturable_texto}</td>"; // <-- NUEVA COLUMNA
            $html .= "<td><span class='badge {$clase_estado}'>{$t['estado']}</span></td>";
            $html .= "<td>{$fecha}</td>";
            $html .= "</tr>";
        }
        echo $html;
    } else {
        // ================== COLSPAN ACTUALIZADO A 10 ==================
        echo "<tr><td colspan='10' class='text-center'>No hay traslados registrados.</td></tr>";
    }

} catch (PDOException $e) {
    // ================== COLSPAN ACTUALIZADO A 10 ==================
    echo "<tr><td colspan='10' class='text-center text-danger'>Error de base de datos: " . $e->getMessage() . "</td></tr>";
}
?>