<?php
/**
 * API: Obtener Sucursales
 * Retorna lista de sucursales
 */

header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json; charset=utf-8');

require_once '../config/database.php';

try {
    $pdo = getDBConnection();
    
    $sql = "SELECT 
                id,
                nombre,
                direccion
            FROM sucursales
            ORDER BY nombre ASC";
    
    $stmt = $pdo->query($sql);
    $sucursales = $stmt->fetchAll();
    
    sendJSON([
        'success' => true,
        'data' => $sucursales
    ]);
    
} catch (PDOException $e) {
    error_log("Error al obtener sucursales: " . $e->getMessage());
    sendJSON(['success' => false, 'error' => 'Error al obtener sucursales'], 500);
}
