<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestión de IVA por Producto</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background-color: #f8f9fa; }
        .container { max-width: 900px; }
        .card { margin-top: 20px; }
        .form-check-input:checked {
            background-color: #198754; /* Verde */
            border-color: #198754;
        }
        .form-check-input {
             cursor: pointer;
        }
        .form-label b {
            font-size: 0.9em;
        }
    </style>
</head>
<body>
    <div class="container my-4">
        <div class="card shadow-sm">
            <div class="card-header bg-primary text-white">
                <h4 class="mb-0">Actualizar IVA Exento de Productos</h4>
            </div>
            <div class="card-body">
                <form method="GET" action="">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label for="laboratorio" class="form-label"><b>Laboratorio:</b></label>
                            <input type="text" class="form-control" id="laboratorio" name="laboratorio" placeholder="Filtrar por laboratorio" value="<?php echo isset($_GET['laboratorio']) ? htmlspecialchars($_GET['laboratorio']) : ''; ?>">
                        </div>
                        <div class="col-md-6">
                            <label for="nombre" class="form-label"><b>Nombre Comercial:</b></label>
                            <input type="text" class="form-control" id="nombre" name="nombre" placeholder="Filtrar por nombre" value="<?php echo isset($_GET['nombre']) ? htmlspecialchars($_GET['nombre']) : ''; ?>">
                        </div>
                        <div class="col-md-6">
                             <label for="codigo" class="form-label"><b>Código Interno:</b></label>
                            <input type="text" class="form-control" id="codigo" name="codigo" placeholder="Filtrar por código" value="<?php echo isset($_GET['codigo']) ? htmlspecialchars($_GET['codigo']) : ''; ?>">
                        </div>
                        <div class="col-md-6 d-flex align-items-end">
                            <button class="btn btn-primary w-100" type="submit">Buscar Productos</button>
                        </div>
                    </div>
                </form>

                <?php
                // Procesar la búsqueda si se envió al menos un filtro
                if (!empty($_GET['laboratorio']) || !empty($_GET['nombre']) || !empty($_GET['codigo'])) {
                    include 'db_connection.php'; // Incluye tu archivo de conexión

                    // --- CONSTRUCCIÓN DE CONSULTA DINÁMICA ---
                    $sql_base = "SELECT id, NombreComercial, CodigoInterno, Laboratorio, exento_iva FROM productos WHERE 1=1";
                    $params = [];
                    $types = '';

                    if (!empty($_GET['laboratorio'])) {
                        $sql_base .= " AND Laboratorio LIKE ?";
                        $params[] = '%' . $_GET['laboratorio'] . '%';
                        $types .= 's';
                    }
                    if (!empty($_GET['nombre'])) {
                        $sql_base .= " AND NombreComercial LIKE ?";
                        $params[] = '%' . $_GET['nombre'] . '%';
                        $types .= 's';
                    }
                    if (!empty($_GET['codigo'])) {
                        $sql_base .= " AND CodigoInterno LIKE ?";
                        $params[] = '%' . $_GET['codigo'] . '%';
                        $types .= 's';
                    }
                    
                    $sql_base .= " ORDER BY NombreComercial ASC"; // Ordenar alfabéticamente

                    $stmt = $conn->prepare($sql_base);
                    if ($types) { // Solo vincular parámetros si hay alguno
                        $stmt->bind_param($types, ...$params);
                    }
                    $stmt->execute();
                    $result = $stmt->get_result();

                    if ($result->num_rows > 0) {
                        echo '<hr/><div class="alert alert-success">Mostrando ' . $result->num_rows . ' productos.</div>';
                        echo '<table class="table table-striped table-hover">';
                        echo '<thead class="table-dark"><tr><th>Producto</th><th>Laboratorio</th><th>Código</th><th class="text-center">Exento IVA</th></tr></thead>';
                        echo '<tbody>';
                        while ($row = $result->fetch_assoc()) {
                            $checked = $row['exento_iva'] ? 'checked' : '';
                            echo '<tr>';
                            echo '<td>' . htmlspecialchars($row['NombreComercial']) . '</td>';
                            echo '<td>' . htmlspecialchars($row['Laboratorio']) . '</td>';
                            echo '<td>' . htmlspecialchars($row['CodigoInterno']) . '</td>';
                            echo '<td class="text-center">';
                            echo '<div class="form-check form-switch d-inline-block">';
                            echo '<input class="form-check-input" type="checkbox" role="switch" data-id="' . $row['id'] . '" ' . $checked . '>';
                            echo '</div>';
                            echo '</td>';
                            echo '</tr>';
                        }
                        echo '</tbody></table>';
                    } else {
                        echo '<hr/><div class="alert alert-warning mt-3">No se encontraron productos con los filtros especificados.</div>';
                    }
                    $stmt->close();
                    $conn->close();
                }
                ?>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.7.0.js"></script>
    <script>
    $(document).ready(function() {
        // La lógica de JavaScript no necesita cambios, seguirá funcionando igual.
        $('.form-check-input').on('change', function() {
            var productId = $(this).data('id');
            var isChecked = $(this).is(':checked') ? 1 : 0;
            var switchElement = $(this);

            switchElement.prop('disabled', true);

            $.ajax({
                url: 'actualizar_iva.php',
                type: 'POST',
                data: {
                    id_producto: productId,
                    exento_iva: isChecked
                },
                dataType: 'json',
                success: function(response) {
                    if (!response.success) {
                        alert('Error al actualizar el producto: ' + response.message);
                        switchElement.prop('checked', !isChecked);
                    }
                },
                error: function() {
                    alert('Error de conexión. No se pudo guardar el cambio.');
                    switchElement.prop('checked', !isChecked);
                },
                complete: function() {
                    switchElement.prop('disabled', false);
                }
            });
        });
    });
    </script>
</body>
</html>