<?php
// get_total_dia_simplificado.php
date_default_timezone_set('America/Guatemala'); // Ajusta la zona horaria según tu ubicación
include 'db_connection.php';
include 'sucursal_config.php';

$sql = "SELECT COALESCE(SUM(total),0) AS total_hoy
        FROM ventas
        WHERE DATE(fecha_y_hora) = CURDATE()
          AND sucursal_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $sucursal_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result && $row = $result->fetch_assoc()) {
    echo json_encode([
        'success' => true,
        'total'   => (float)$row['total_hoy']
    ]);
} else {
    echo json_encode([
        'success' => false,
        'total'   => 0
    ]);
}
?>
