<?php
// php_logic/actualizar_lote.php

require_once 'db_connection.php';
header('Content-Type: application/json');

// Verificamos que los datos necesarios fueron enviados por POST
if (!isset($_POST['lote_id'], $_POST['fechavencimiento'], $_POST['codigobarra'], $_POST['sefactura'])) {
    die(json_encode(['success' => false, 'message' => 'Faltan datos.']));
}

$lote_id = $_POST['lote_id'];
$fechavencimiento = $_POST['fechavencimiento'];
$codigobarra = $_POST['codigobarra'];
$sefactura = $_POST['sefactura'];

// Preparamos la consulta UPDATE para la tabla 'lote'
$stmt = $conexion->prepare("UPDATE lote SET fechavencimiento = ?, codigobarra = ?, sefactura = ? WHERE id = ?");

if ($stmt) {
    $stmt->bind_param("ssii", $fechavencimiento, $codigobarra, $sefactura, $lote_id);
    
    if ($stmt->execute()) {
        if ($stmt->affected_rows > 0) {
            echo json_encode(['success' => true, 'message' => 'Lote actualizado correctamente.']);
        } else {
            echo json_encode(['success' => true, 'message' => 'No se realizaron cambios.']);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'Error al ejecutar la actualización.']);
    }
    $stmt->close();
} else {
    echo json_encode(['success' => false, 'message' => 'Error al preparar la consulta.']);
}

$conexion->close();