<?php
require_once 'db_connection.php';
header('Content-Type: application/json');

$respuesta = [];

if (isset($_POST['termino'])) {
    $termino_busqueda = trim($_POST['termino']);
    // Dividimos el término de búsqueda en palabras individuales
    $palabras = explode(' ', $termino_busqueda);
    $palabras = array_filter($palabras); // Elimina palabras vacías

    $condiciones = [];
    $parametros = [];
    $tipos = '';

    // Construimos una condición LIKE para cada palabra
    foreach ($palabras as $palabra) {
        $palabra_like = "%" . $palabra . "%";
        $condiciones[] = "(NombreComercial LIKE ? OR laboratorio LIKE ? OR CodigoInterno LIKE ? OR CodigoBarra LIKE ?)";
        // Añadimos 4 parámetros 's' (string) por cada palabra
        $tipos .= 'ssss';
        array_push($parametros, $palabra_like, $palabra_like, $palabra_like, $palabra_like);
    }
    
    // Unimos todas las condiciones con AND
    $sql_condiciones = implode(' AND ', $condiciones);

    $sql = "SELECT id, CodigoInterno, CodigoBarra, NombreComercial, laboratorio FROM productos WHERE " . $sql_condiciones . " LIMIT 10";
    
    $stmt = $conexion->prepare($sql);
    if ($stmt) {
        // Usamos el "splat operator" (...) para pasar el array de parámetros
        $stmt->bind_param($tipos, ...$parametros);
    }

} elseif (isset($_POST['id_exacto'])) {
    $id = $_POST['id_exacto'];
    $stmt = $conexion->prepare("SELECT id, CodigoInterno, CodigoBarra, NombreComercial, laboratorio FROM productos WHERE id = ?");
    $stmt->bind_param("i", $id);
} else {
    echo json_encode([]);
    exit;
}

if ($stmt) {
    $stmt->execute();
    $resultado = $stmt->get_result();
    while ($fila = $resultado->fetch_assoc()) {
        $respuesta[] = $fila;
    }
    $stmt->close();
}

$conexion->close();

echo json_encode($respuesta);