# Sistema de Pedidos de Medicamentos - Sufarma

Sistema completo para gestionar pedidos de medicamentos entre sucursales de farmacia.

## 🚀 Características

- ✅ Búsqueda avanzada de productos (código interno, código de barras, nombre + laboratorio, laboratorio)
- ✅ Gestión de pedidos por sucursal
- ✅ Prioridad de pedidos (urgente/normal)
- ✅ Control de existencias y presentaciones
- ✅ Interfaz moderna con TailwindCSS
- ✅ Búsqueda en tiempo real con AJAX
- ✅ Diseño responsive

## 📋 Requisitos

- WAMP/XAMPP/LAMP
- PHP 7.4 o superior
- MySQL 5.7 o superior
- Navegador web moderno

## 🔧 Instalación

### 1. Importar Base de Datos

Abre phpMyAdmin y ejecuta el archivo `migration.sql`:

```bash
# O desde línea de comandos:
mysql -u root -p sufarma < migration.sql
```

### 2. Configurar Base de Datos

Edita el archivo `config/database.php` si es necesario:

```php
define('DB_HOST', 'localhost');
define('DB_PORT', '3306');
define('DB_NAME', 'sufarma');
define('DB_USER', 'root');
define('DB_PASS', '');
```

### 3. Acceder al Sistema

Abre tu navegador y ve a:

```
http://localhost/Pedidos/
```

## 📖 Uso del Sistema

### Crear un Pedido

1. **Selecciona la sucursal** que está haciendo el pedido
2. **Busca productos** usando el buscador:
   - Por código interno
   - Por código de barras
   - Por nombre + laboratorio
   - Por laboratorio
3. **Agrega productos** al pedido haciendo clic en el botón "+"
4. **Configura cada producto**:
   - Marca como urgente si es necesario
   - Indica la existencia actual y su presentación
   - Define la cantidad solicitada y su presentación
5. **Selecciona el usuario** que realiza el pedido
6. **Agrega observaciones** si es necesario
7. **Envía el pedido**

### Campos del Pedido

Cada producto en el pedido incluye:

- **Códigos**: Código interno y código de barras (uno debajo del otro)
- **Prioridad**: Toggle para marcar como urgente
- **Nombre y Laboratorio**: Uno debajo del otro
- **Existencia Actual**: Cantidad que tiene + presentación
- **Cantidad Solicitada**: Cuánto necesita + presentación
- **Usuario**: Quien hace el pedido
- **Fecha**: Se registra automáticamente

## 🗂️ Estructura del Proyecto

```
Pedidos/
├── api/
│   ├── get_branches.php      # Obtener sucursales
│   ├── get_stock.php          # Obtener stock
│   ├── get_users.php          # Obtener usuarios
│   ├── save_order.php         # Guardar pedido
│   └── search_products.php    # Buscar productos
├── config/
│   └── database.php           # Configuración DB
├── css/
│   └── custom.css             # Estilos personalizados
├── js/
│   └── app.js                 # Lógica principal
├── index.html                 # Interfaz principal
├── migration.sql              # Script de base de datos
└── README.md                  # Este archivo
```

## 🎨 Tecnologías Utilizadas

- **Frontend**: HTML5, TailwindCSS, JavaScript (Vanilla)
- **Backend**: PHP 8.x, MySQL
- **Comunicación**: AJAX (Fetch API)
- **Diseño**: Responsive, Mobile-first

## 📊 Base de Datos

### Tabla: `pedidos`

Almacena los pedidos principales con información de sucursal, usuario, fecha y estado.

### Tabla: `detalle_pedidos`

Almacena los productos de cada pedido con todos los detalles:
- Códigos del producto
- Prioridad (urgente/normal)
- Existencia actual y presentación
- Cantidad solicitada y presentación

## 🔐 Estados de Pedido

- `pendiente`: Pedido creado, esperando aprobación
- `aprobado`: Pedido aprobado por administrador
- `enviado`: Productos en tránsito
- `completado`: Pedido recibido
- `cancelado`: Pedido cancelado

## 🎯 Presentaciones Disponibles

- UNIDAD
- BLISTER
- CAJA
- BOTE
- PAQUETE
- FARDO
- BOLSA
- GALÓN

## 🐛 Solución de Problemas

### Error de conexión a la base de datos

Verifica que:
- WAMP/XAMPP esté corriendo
- Las credenciales en `config/database.php` sean correctas
- La base de datos `sufarma` exista

### No aparecen productos en la búsqueda

Verifica que:
- La tabla `productos` tenga datos
- El campo `estado` de los productos sea `1` (activo)
- La sucursal seleccionada tenga inventario

### No se puede enviar el pedido

Verifica que:
- Hayas seleccionado una sucursal
- Hayas seleccionado un usuario
- Hayas agregado al menos un producto

## 📝 Licencia

Sistema desarrollado para Sufarma - Uso interno

## 👨‍💻 Soporte

Para soporte técnico, contacta al administrador del sistema.
