<?php
/**
 * API: Obtener Sucursal Actual
 * Retorna la sucursal configurada actualmente
 */

header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json; charset=utf-8');

require_once '../config/database.php';
require_once '../config/branch.php';

try {
    $pdo = getDBConnection();
    $currentBranchId = getCurrentBranchId();
    
    $stmt = $pdo->prepare("SELECT id, nombre, direccion FROM sucursales WHERE id = ?");
    $stmt->execute([$currentBranchId]);
    $sucursal = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($sucursal) {
        sendJSON([
            'success' => true,
            'data' => $sucursal
        ]);
    } else {
        sendJSON([
            'success' => false, 
            'error' => 'Sucursal configurada no encontrada',
            'config_id' => $currentBranchId
        ], 404);
    }
    
} catch (PDOException $e) {
    error_log("Error al obtener sucursal actual: " . $e->getMessage());
    sendJSON(['success' => false, 'error' => 'Error de base de datos'], 500);
}
