<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Facturación SAT</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f8f9fa;
        }
        .details-card {
            background: white;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            padding: 5px;
            height: 100vh;
            overflow-y: auto;
        }
        .iframe-container {
            height: 100vh;
            border-radius: 8px;
            overflow: hidden;
        }
        iframe {
            width: 100%;
            height: 100%;
            border: none;
            border-radius: 8px;
        }
        .table {
            font-size: 0.85rem;
        }
        .table th {
            background-color: #0C2659;
            color: white;
        }
        .total-row {
            font-weight: bold;
            background-color: #f8f9fa;
        }
        /* Estilos para desactivar el botón */
        .disabled-link {
            pointer-events: none;
            opacity: 0.6;
        }
    </style>
</head>
<body>

    <h5>Datos de inicio de sesión: NIT = 120429144, Usuario: Sufarma1, Contraseña: Sufarma777!</h5>

    <div class="container-fluid py-3">
        <div class="row">
            <!-- Columna principal con iframe -->
            <div class="col-md-10">
                <div class="iframe-container">
                    <iframe src="https://totalpos.totaldoc.com/billing/new?type=FACT" allowfullscreen></iframe>
                </div>
            </div>
            
            <!-- Columna de detalles -->
            <div class="col-md-2">
                <div class="details-card">
                    <h4 class="mb-4" id="totalVenta">Total: Q 0.00</h4>

                    <div id="detallesVenta">
                        <!-- Los detalles de la venta aparecerán aquí -->
                    </div>

                    <hr class="my-4">

                    <div class="form-check mb-3">
                        <input class="form-check-input" type="checkbox" id="ventaFacturada">
                        <label class="form-check-label" for="ventaFacturada">
                            Venta Facturada
                        </label>
                    </div>

                    <a href="index_simplificado.php" class="btn btn-primary w-100 disabled-link" id="btnRegresar">
                        Regresar a Principal
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            // Variables
            const urlParams = new URLSearchParams(window.location.search);
            const ventaId = urlParams.get('venta_id');
            const tipoVenta = urlParams.get('tipo');

            const $btnRegresar = $('#btnRegresar');
            const $ventaFacturada = $('#ventaFacturada');
            const $detallesVenta = $('#detallesVenta');
            const $totalVenta = $('#totalVenta');

            // Cargar detalles de la venta si existen parámetros
            if (ventaId && tipoVenta) {
                const endpoint = 'get_detalle_venta_unificado.php';
                
                $.get(endpoint, { venta_id: ventaId, tipo: tipoVenta }, function(response) {
                    if (response.success) {
                        let detallesHtml = `
                            <table class="table table-bordered table-striped">
                                <tbody>
                        `;

                        response.venta.productos.forEach(producto => {
                            detallesHtml += `
                                <tr>
                                    <td width="30%">
                                        <div><strong>Código:</strong> ${producto.codigo_interno || 'N/A'}</div>
                                        <div><strong>Cantidad:</strong> ${producto.cantidad || '0'}</div>
                                        <div><strong>Subtotal:</strong> Q ${producto.subtotal || '0.00'}</div>
                                    </td>
                                    <td width="70%"><strong>Nombre:</strong> ${producto.nombre || 'N/A'}</td>
                                </tr>
                            `;
                        });

                        detallesHtml += `
                                </tbody>
                            </table>
                        `;

                        $detallesVenta.html(detallesHtml);
                        $totalVenta.html('Total: Q ' + (response.venta.total || '0.00'));
                    } else {
                        $detallesVenta.html('<div class="alert alert-danger">Error al cargar los detalles</div>');
                    }
                }).fail(function() {
                    $detallesVenta.html('<div class="alert alert-danger">Error de conexión</div>');
                });
            } else {
                $detallesVenta.html('<div class="alert alert-warning">No se proporcionó ID de venta</div>');
            }

            // Evento: Habilitar o deshabilitar el botón según el checkbox
            $ventaFacturada.change(function() {
                const isChecked = $(this).is(':checked');
                
                if (isChecked) {
                    $btnRegresar.removeClass('disabled-link');
                    
                    if (ventaId && tipoVenta) {
                        // Actualizar el estado de los productos a FACTURADO
                        $.ajax({
                            url: 'actualizar_estado_facturacion.php',
                            method: 'POST',
                            data: {
                                venta_id: ventaId,
                                tipo_venta: tipoVenta,
                                estado: 'FACTURADO'
                            },
                            success: function(response) {
                                if (!response.success) {
                                    alert('Error al actualizar el estado de los productos');
                                    $ventaFacturada.prop('checked', false);
                                    $btnRegresar.addClass('disabled-link');
                                }
                            },
                            error: function() {
                                alert('Error de conexión al actualizar el estado');
                                $ventaFacturada.prop('checked', false);
                                $btnRegresar.addClass('disabled-link');
                            }
                        });
                    }
                } else {
                    $btnRegresar.addClass('disabled-link');
                }
            });
        });
    </script>

</body>
</html>
