<?php
// finalizar_venta_simplificado.php
date_default_timezone_set('America/Guatemala'); // Ajusta la zona horaria según tu ubicación
include 'db_connection.php';
include 'sucursal_config.php';

// 1. Recibir datos
$cartJson = $_POST['cart'] ?? '[]';
$cart = json_decode($cartJson, true);

if (!is_array($cart) || count($cart) === 0) {
    echo json_encode([
        'success' => false,
        'message' => 'El carrito está vacío.'
    ]);
    exit;
}

// 2. Calculamos total (lado servidor, por seguridad)
$total = 0;
foreach ($cart as $item) {
    $price    = (float)($item['price'] ?? 0);
    $quantity = (int)($item['quantity'] ?? 1);
    $total   += $price * $quantity;
}

// 3. Insertar en ventas
$usuarioId  = 1;  // Fijo (ajusta según tu lógica)
$clienteId  = 1;  // Fijo (ej. Consumidor Final)
$idTipoPago = 1;  // Fijo
$montoEf    = 0;
$montoTar   = 0;

$fecha = date('Y-m-d H:i:s');

$sqlVenta = "INSERT INTO ventas 
    (fecha_y_hora, total, usuario_id, cliente_id, sucursal_id, id_tipopago, monto_efectivo, monto_tarjeta)
    VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
$stmtVenta = $conn->prepare($sqlVenta);
$stmtVenta->bind_param("sdiiiidd", $fecha, $total, $usuarioId, $clienteId, $sucursal_id, $idTipoPago, $montoEf, $montoTar);

if (!$stmtVenta->execute()) {
    echo json_encode([
        'success' => false,
        'message' => 'Error al insertar venta: ' . $stmtVenta->error
    ]);
    exit;
}

$ventaId = $stmtVenta->insert_id;

// 4. Insertar detalle
foreach ($cart as $item) {
    $nombreComercial = $item['name']  ?? '';
    $laboratorio     = $item['lab']   ?? '';
    $precio          = (float)($item['price'] ?? 0);
    $cantidad        = (int)($item['quantity'] ?? 1);
    $subtotal        = $precio * $cantidad;

    // Buscar el producto
    $sqlProd = "SELECT id FROM productos 
                WHERE NombreComercial = ? AND laboratorio = ? 
                LIMIT 1";
    $stmtProd = $conn->prepare($sqlProd);
    $stmtProd->bind_param("ss", $nombreComercial, $laboratorio);
    $stmtProd->execute();
    $resProd = $stmtProd->get_result();

    if ($resProd->num_rows > 0) {
        $prodData = $resProd->fetch_assoc();
        $productoId = $prodData['id'];

        // Insertar en detalle
        $sqlDet = "INSERT INTO detalle_ventas
                   (venta_id, producto_id, cantidad, precio, subtotal, facturado)
                   VALUES (?, ?, ?, ?, ?, ?)";
        $stmtDet = $conn->prepare($sqlDet);
        $facturado = isset($item['facturar']) && $item['facturar'] ? 1 : 0;
        $stmtDet->bind_param("iiiddi", $ventaId, $productoId, $cantidad, $precio, $subtotal, $facturado);
        if (!$stmtDet->execute()) {
            echo json_encode([
                'success' => false,
                'message' => 'Error al insertar detalle de venta: ' . $stmtDet->error
            ]);
            exit;
        }
    }
}

// 5. Retornar éxito
echo json_encode([
    'success' => true,
    'venta_id' => $ventaId,
    'message'  => 'Venta registrada exitosamente.'
]);
exit;
?>
