<?php
// get_detalle_venta.php
date_default_timezone_set('America/Guatemala'); // Ajusta la zona horaria según tu ubicación
include 'db_connection.php';
include 'sucursal_config.php';

// Recibir el id de la venta
$venta_id = isset($_GET['venta_id']) ? intval($_GET['venta_id']) : 0;

// Detectar si se solicita en formato JSON o HTML
$format = isset($_GET['format']) ? $_GET['format'] : 'html';

if ($venta_id <= 0) {
    if($format === 'json'){
        echo json_encode([
            'success' => false,
            'message' => 'Venta inválida.'
        ]);
    } else {
        echo "<p>Venta inválida.</p>";
    }
    exit;
}

// Query para obtener el detalle
$sqlDet = "
    SELECT dv.cantidad, dv.precio, dv.subtotal, dv.facturado, dv.estado_factura,
           p.NombreComercial, p.laboratorio
    FROM detalle_ventas dv
    JOIN productos p ON dv.producto_id = p.id
    WHERE dv.venta_id = ?
";
$stmt = $conn->prepare($sqlDet);
$stmt->bind_param("i", $venta_id);
$stmt->execute();
$res = $stmt->get_result();

if (!$res || $res->num_rows === 0) {
    if($format === 'json'){
        echo json_encode([
            'success' => false,
            'message' => 'No hay detalle para esta venta.'
        ]);
    } else {
        echo "<p>No hay detalle para esta venta.</p>";
    }
    exit;
}

if($format === 'json'){
    $detalle = [];
    while ($row = $res->fetch_assoc()) {
        $detalle[] = [
            'NombreComercial' => htmlspecialchars($row['NombreComercial'], ENT_QUOTES, 'UTF-8'),
            'laboratorio'     => htmlspecialchars($row['laboratorio'], ENT_QUOTES, 'UTF-8'),
            'cantidad'        => (int)$row['cantidad'],
            'precio'          => $row['precio'],
            'subtotal'        => $row['subtotal'],
            'facturado'       => (bool)$row['facturado'],
            'estado_factura'  => $row['facturado'] ? ($row['estado_factura'] ?: 'Pendiente') : '-'
        ];
    }
    echo json_encode([
        'success' => true,
        'detalle' => $detalle
    ]);
} else {
    // Generar tabla HTML
    $output = '<table class="table table-sm">';
    $output .= '<thead>
        <tr>
          <th>Producto</th>
          <th>Laboratorio</th>
          <th>Cantidad</th>
          <th>Precio</th>
          <th>Subtotal</th>
          <th>Facturado</th>
          <th>Estado Factura</th>
        </tr>
    </thead>
    <tbody>';
    while ($row = $res->fetch_assoc()) {
        $nombre   = htmlspecialchars($row['NombreComercial'], ENT_QUOTES, 'UTF-8');
        $lab      = htmlspecialchars($row['laboratorio'], ENT_QUOTES, 'UTF-8');
        $cant     = (int)$row['cantidad'];
        $precio   = number_format($row['precio'], 2);
        $subtotal = number_format($row['subtotal'], 2);
        $facturado = $row['facturado'] ? 'Sí' : 'No';

        $estadoFactura = $row['facturado'] ? ($row['estado_factura'] ?: 'Pendiente') : '-';
        $output .= "<tr>
            <td>{$nombre}</td>
            <td>{$lab}</td>
            <td>{$cant}</td>
            <td>Q {$precio}</td>
            <td>Q {$subtotal}</td>
            <td>{$facturado}</td>
            <td>{$estadoFactura}</td>
        </tr>";
    }
    $output .= '</tbody></table>';

    echo $output;
}
?>
