<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Sistema de Ventas Simplificado</title>

    <!-- Bootstrap 5 -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    
    <!-- Estilos simples -->
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #F2F2F2;
        }
        .page-title {
            color: #0C2659;
            font-weight: 500;
        }
        #searchBar {
            border: 2px solid #0C2659;
        }
        #searchBar:focus {
            border-color: #00AC76;
            box-shadow: 0 0 4px rgba(0,172,118,0.4);
        }
        .btn-primary {
            background-color: #0C2659;
            border-color: #0C2659;
        }
        .btn-primary:hover {
            background-color: #07306C;
        }
        .list-group-item {
            font-size: 0.85rem;
        }
        #cartItems {
            max-height: 300px;
            overflow-y: auto;
        }
        /* Para separar la sección de totales */
        .totales-dias {
            background: #fff;
            padding: 1rem;
            border: 1px solid #ddd;
            border-radius: 5px;
        }
        .totales-dias h5 {
            margin: 0;
            font-size: 1rem;
        }
        /* Estilo para el modal de Últimas 7 Ventas */
        .modal-xl {
            max-width: 70%; /* Aumenta el ancho del modal */
        }
        /* Ajuste para los botones en la tabla de Últimas 7 Ventas */
        #tablaUltimasVentas td .btn {
            margin: 0.2rem; /* Espacio entre botones */
            padding: 0.25rem 0.5rem; /* Botones más pequeños */
            font-size: 0.85rem; /* Texto más pequeño */
        }
        #tablaUltimasVentas td {
            vertical-align: middle; /* Centrar verticalmente el contenido */
        }
    </style>
</head>
<body>

<div class="container-fluid py-3">
    <div class="row mb-3">
        <!-- Encabezado: Totales de Hoy + Sucursal -->
        <div class="col-md-6">
            <h2 class="page-title">
                Ventas de Hoy <span id="sucursalName"></span>
            </h2>
        </div>
        <!-- Botones: Venta Especial, Ver Ventas, Registrar Stock -->
        <div class="col-md-6 text-end">
            <button class="btn btn-danger" id="btnVentaEspecial">
                Venta ESPECIAL
            </button>
            <!-- BOTÓN PARA Ver Ventas (NUEVO) -->
            <a href="ver_ventas.php" class="btn btn-info">
                Ver Ventas
            </a>
            <a href="verfacturas.php" class="btn btn-warning">
                Ver Mis Facturas
            </a>

            <a href="https://sufarmachiqui.farmaciasjireh.com/inventarioch/inventario.php" class="btn btn-primary">
                Ir a Inventarios
            </a>
            
            <a href="https://sufarmachiqui.farmaciasjireh.com/traslado/traslados.php" class="btn btn-primary">
                Ir a Traslados
            </a>
        </div>
    </div>

    <!-- Sección de Totales (Normal, Especial, Gran Total) -->
    <div class="row">
        <div class="col-md-12">
            <div class="totales-dias d-flex gap-3 mb-3">
                <h5>Total Normal: Q <span id="salesTodayNormal">0.00</span></h5>
                <h5>Total Especial: Q <span id="salesTodayEspecial">0.00</span></h5>
                <h5>Gran Total: Q <span id="salesTodayGrand">0.00</span></h5>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Columna izquierda: buscar productos -->
        <div class="col-md-8">
            <div class="mb-2">
                <input type="text" id="searchBar" class="form-control" 
                       placeholder="Buscar por código, nombre o laboratorio...">
            </div>

            <div id="productTable">
                <!-- Aquí se carga la tabla (buscar_productos_simplificado.php) -->
            </div>
        </div>

        <!-- Columna derecha: carrito -->
        <div class="col-md-4">
            <h4>Total Carrito: Q <span id="cartTotal">0.00</span></h4>
            <ul id="cartItems" class="list-group"></ul>
            <hr>
            <button id="btnVender" class="btn btn-success w-100 mt-2">
                Vender (Normal)
            </button>
            <button id="btnImprimirTicket" class="btn btn-info w-100 mt-2" style="display: none;">
                Imprimir Ticket Factura
            </button>
            <!-- Nuevo Botón para Ver Últimas 7 Ventas -->
            <button id="btnVerUltimasVentas" class="btn btn-secondary w-100 mt-2">
                Ver Últimas 7 Ventas
            </button>
            
            <!-- Últimas 3 Ventas -->
            <div class="card mt-3">
                <div class="card-header bg-secondary text-white">
                    <h6 class="mb-0">Últimas 3 Ventas</h6>
                </div>
                <div class="card-body p-2" id="ultimas3Ventas">
                    <div class="text-center">
                        <div class="spinner-border text-primary" role="status">
                            <span class="visually-hidden">Cargando...</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- ========================================= -->
<!--   MODAL: Venta Especial                  -->
<!-- ========================================= -->
<div class="modal fade" id="modalVentaEspecial" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog">
    <form id="formVentaEspecial">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Registrar Venta Especial</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body">
          <!-- Descripción -->
          <div class="mb-3">
            <label for="descripcionEspecial" class="form-label">Descripción</label>
            <input type="text" id="descripcionEspecial" name="descripcionEspecial" class="form-control" required>
          </div>
          <!-- Precio -->
          <div class="mb-3">
            <label for="precioEspecial" class="form-label">Precio (Q)</label>
            <input type="number" step="0.01" id="precioEspecial" name="precioEspecial" class="form-control" required>
          </div>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">Guardar Venta Especial</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
        </div>
      </div>
    </form>
  </div>
</div>

<!-- ========================================= -->
<!--   MODAL: Últimas 7 Ventas                -->
<!-- ========================================= -->
<div class="modal fade" id="modalUltimasVentas" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-xl">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Últimas 7 Ventas</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <!-- Tabla de Ventas -->
        <table class="table table-bordered" id="tablaUltimasVentas">
          <thead>
            <tr>
              <th>ID</th>
              <th>Fecha/Hora</th>
              <th>Total</th>
              <th>Tipo</th>
              <th>Acción</th>
              <th>Facturar SAT</th>
            </tr>
          </thead>
          <tbody>
            <!-- Contenido generado vía JS -->
          </tbody>
        </table>
      </div>
      <div class="modal-footer d-flex justify-content-between">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
      </div>
    </div>
  </div>
</div>

<!-- ========================================= -->
<!--   MODAL: Editar Venta Especial           -->
<!-- ========================================= -->
<div class="modal fade" id="modalEditarVentaEspecial" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog">
    <form id="formEditarVentaEspecial">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Editar Venta Especial</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body">
          <!-- ID de la Venta (oculto) -->
          <input type="hidden" id="editVentaEspecialId" name="editVentaEspecialId">
          <!-- Descripción -->
          <div class="mb-3">
            <label for="editDescripcionEspecial" class="form-label">Descripción</label>
            <input type="text" id="editDescripcionEspecial" name="editDescripcionEspecial" class="form-control" required>
          </div>
          <!-- Precio -->
          <div class="mb-3">
            <label for="editPrecioEspecial" class="form-label">Precio (Q)</label>
            <input type="number" step="0.01" id="editPrecioEspecial" name="editPrecioEspecial" class="form-control" required>
          </div>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">Actualizar Venta Especial</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
        </div>
      </div>
    </form>
  </div>
</div>

<!-- ========================================= -->
<!--   MODAL: Confirmar Eliminación           -->
<!-- ========================================= -->
<div class="modal fade" id="modalConfirmarEliminar" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog">
    <form id="formConfirmarEliminar">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Confirmar Eliminación</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body">
          <p>¿Está seguro de que desea eliminar esta venta?</p>
          <!-- ID y Tipo de la Venta (ocultos) -->
          <input type="hidden" id="eliminarVentaId" name="eliminarVentaId">
          <input type="hidden" id="eliminarVentaTipo" name="eliminarVentaTipo">
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-danger">Eliminar</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
        </div>
      </div>
    </form>
  </div>
</div>

<!-- Bootstrap & jQuery -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<!-- Script de impresión -->
<script src="js/print_ticket.js"></script>

<!-- Script principal -->
<script>
// ============================
// Variables globales
// ============================
let cart = [];
let total = 0;

// Variable para almacenar la venta en modificación
let ventaEnModificacion = null;

// ============================
// Función cargar productos
// ============================
function loadProducts(query = '', page = 1) {
    $.get('buscar_productos_simplificado.php', { query, page }, function(data) {
        $('#productTable').html(data);
    });
}

// ============================
// Actualizar carrito (DOM)
// ============================
function updateCart() {
    let cartHtml = '';
    total = 0;

    cart.forEach(item => {
        let subtotal = item.price * item.quantity;
        total += subtotal;
        cartHtml += `
            <li class="list-group-item d-flex justify-content-between align-items-center">
                <div>
                    <strong>${item.name}</strong> (${item.lab})<br>
                    Precio: Q${item.price.toFixed(2)}<br>
                    Cant: 
                    <input type="number" min="1" class="form-control d-inline-block quantity-update" 
                           data-name="${item.name}" 
                           data-lab="${item.lab}" 
                           data-price="${item.price}" 
                           data-facturar="${item.facturar}" 
                           value="${item.quantity}" 
                           style="width:60px;">
                    Subtotal: Q${subtotal.toFixed(2)}<br>
                    <div class="form-check">
                        <input class="form-check-input cart-facturar-check" type="checkbox" 
                               ${item.facturar ? 'checked' : ''}
                               data-name="${item.name}" 
                               data-lab="${item.lab}" 
                               data-price="${item.price}">
                        <label class="form-check-label">Facturar</label>
                    </div>
                </div>
                <button class="btn btn-danger btn-sm remove-item" 
                        data-name="${item.name}" 
                        data-lab="${item.lab}" 
                        data-price="${item.price}">
                    X
                </button>
            </li>
        `;
    });
    $('#cartItems').html(cartHtml);
    $('#cartTotal').text(total.toFixed(2));
}

// ============================
// Función para cargar las últimas 3 ventas
// ============================
function loadUltimas3Ventas() {
    $.ajax({
        url: 'get_last_sales.php',
        method: 'GET',
        dataType: 'json',
        success: function(response) {
            if (response.success) {
                let ventas = response.ventas.slice(0, 3); // Tomar solo las primeras 3 ventas
                let ventasHtml = '';
                
                ventas.forEach(function(venta) {
                    ventasHtml += `
                        <div class="border-bottom pb-2 mb-2">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <strong>${venta.fecha_y_hora}</strong><br>
                                    Total: Q ${parseFloat(venta.total).toFixed(2)}
                                </div>
                                <div>
                                    <button class="btn btn-info btn-sm me-1 imprimir-ticket" 
                                            data-id="${venta.id}">
                                        <i class="fas fa-print"></i> Imprimir
                                    </button>
                                    <button class="btn btn-primary btn-sm facturar-sat" 
                                            data-id="${venta.id}" 
                                            data-tipo="${venta.tipo.toLowerCase()}">
                                        Facturar SAT
                                    </button>
                                </div>
                            </div>
                        </div>
                    `;
                });
                
                if (ventas.length === 0) {
                    ventasHtml = '<div class="text-center">No hay ventas recientes.</div>';
                }
                
                $('#ultimas3Ventas').html(ventasHtml);
            } else {
                $('#ultimas3Ventas').html('<div class="text-center text-danger">No se pudieron cargar las ventas.</div>');
            }
        },
        error: function() {
            $('#ultimas3Ventas').html('<div class="text-center text-danger">Error de comunicación con el servidor.</div>');
        }
    });
}

// ============================
// Document Ready
// ============================
$(document).ready(function(){
    // Evento para ver detalle de venta (últimas 3 ventas)
    $(document).on('click', '.ver-detalle-venta', function() {
        const ventaId = $(this).data('id');
        const tipo = $(this).data('tipo');
        const rowDetalle = $('#detalle-venta-' + ventaId);
        const content = rowDetalle.find('.detalle-content');

        // Si el detalle ya está visible y tiene contenido, solo lo ocultamos
        if (rowDetalle.is(':visible')) {
            rowDetalle.slideUp();
            return;
        }

        // Si el detalle está oculto, hacemos la petición AJAX
        $.ajax({
            url: tipo === 'Normal' ? 'get_detalle_venta.php?format=html' : 'get_detalle_venta_especial.php?format=html',
            method: 'GET',
            data: { venta_id: ventaId },
            dataType: 'html',
            success: function(response) {
                content.html(response);
                rowDetalle.slideDown();
            },
            error: function() {
                content.html('<p style="color:red;">Error al cargar el detalle.</p>');
                rowDetalle.slideDown();
            }
        });
    });

    // Evento para imprimir ticket
    $(document).on('click', '.imprimir-ticket', function() {
        const ventaId = $(this).data('id');
        imprimirTicket(ventaId);
    });

    // Cargar productos inicial
    loadProducts();
    
    // Cargar últimas 3 ventas
    loadUltimas3Ventas();

    // Buscar mientras teclean
    $('#searchBar').on('keyup', function() {
        let query = $(this).val();
        loadProducts(query, 1);
    });

    // Delegar click para paginación (buscar_productos_simplificado.php)
    $(document).on('click', '.pagination .page-link', function(e){
        e.preventDefault();
        let page = $(this).data('page');
        if (page) {
            let query = $('#searchBar').val();
            loadProducts(query, page);
        }
    });

    // ============================
    // Manejo de checkbox de facturación
    // ============================
    $(document).on('change', '.facturar-check', function() {
        const $checkbox = $(this);
        const $button = $checkbox.closest('.d-flex').find('.add-to-cart');
        
        if ($checkbox.is(':checked')) {
            $button.click();
        }
    });

    // ============================
    // Manejo de "add-to-cart"
    // ============================
    $(document).on('click', '.add-to-cart', function(){
        const name  = $(this).data('name');
        const lab   = $(this).data('lab');
        const price = parseFloat($(this).data('price')) || 0;
        const facturar = $(this).closest('.d-flex').find('.facturar-check').is(':checked');

        let existing = cart.find(i => i.name === name && i.lab === lab && i.price === price);
        if (existing) {
            existing.quantity += 1;
        } else {
            cart.push({ name, lab, price, quantity: 1, facturar });
        }
        updateCart();
    });

    // ============================
    // Actualizar cantidad
    // ============================
    $(document).on('change', '.quantity-update, .cart-facturar-check', function(){
        const name  = $(this).data('name');
        const lab   = $(this).data('lab');
        const price = parseFloat($(this).data('price')) || 0;
        
        let item = cart.find(i => i.name === name && i.lab === lab && i.price === price);
        if (item) {
            if ($(this).hasClass('quantity-update')) {
                item.quantity = parseInt($(this).val());
            } else if ($(this).hasClass('cart-facturar-check')) {
                item.facturar = $(this).prop('checked');
            }
        }
        updateCart();
    });

    // ============================
    // Eliminar item del carrito
    // ============================
    $(document).on('click', '.remove-item', function(){
        const name  = $(this).data('name');
        const lab   = $(this).data('lab');
        const price = parseFloat($(this).data('price')) || 0;

        cart = cart.filter(i => !(i.name === name && i.lab === lab && i.price === price));
        updateCart();
    });

    // ============================
    // Botón "Vender (Normal)"
    // ============================
    $('#btnVender').on('click', function(){
        if (cart.length === 0) {
            showToast('El carrito está vacío.', 'warning');
            return;
        }

        if(ventaEnModificacion){
            // Actualizar una venta existente
            $.ajax({
                url: 'update_sale.php',
                method: 'POST',
                dataType: 'json',
                data: {
                    venta_id: ventaEnModificacion,
                    cart: JSON.stringify(cart)
                },
                success: function(response){
                    if(response.success){
                        showToast('Venta actualizada exitosamente.', 'success');
                        cart = [];
                        updateCart();
                        loadSalesOfDay();
                        loadUltimas3Ventas(); // Actualizar últimas ventas
                        ventaEnModificacion = null;
                    } else {
                        showToast('Error: ' + response.message, 'error');
                    }
                }
            });
        } else {
            // Registrar una venta normal
            $.ajax({
                url: 'finalizar_venta_simplificado.php',
                method: 'POST',
                dataType: 'json',
                data: { cart: JSON.stringify(cart) },
                success: function(response){
                    if(response.success){
                        showToast('Venta registrada exitosamente.', 'success');
                        cart = [];
                        updateCart();
                        loadSalesOfDay();
                        loadUltimas3Ventas(); // Actualizar últimas ventas
                    } else {
                        showToast('Error: ' + response.message, 'error');
                    }
                }
            });
        }
    });

    // ============================
    // Botón "Venta Especial"
    // ============================
    $('#btnVentaEspecial').on('click', function(){
        // Mostrar modal
        $('#modalVentaEspecial').modal('show');
    });

    // Al enviar el formulario de Venta Especial
    $('#formVentaEspecial').on('submit', function(e){
        e.preventDefault();

        let descripcion = $('#descripcionEspecial').val().trim();
        let precio      = parseFloat($('#precioEspecial').val()) || 0;

        $.ajax({
            url: 'finalizar_venta_especial.php',
            method: 'POST',
            dataType: 'json',
            data: {
                descripcion: descripcion,
                precio: precio
            },
            success: function(res){
                if(res.success){
                    // Notificación exitosa
                    showToast('Venta especial registrada exitosamente.', 'success');

                    // Cerrar modal y resetear formulario
                    $('#modalVentaEspecial').modal('hide');
                    $('#formVentaEspecial')[0].reset();
                    loadSalesOfDay();
                } else {
                    // Manejo de errores
                    showToast('Error: ' + res.message, 'danger');
                }
            },
            error: function(){
                // Manejo de errores de comunicación
                showToast('Error de comunicación con el servidor.', 'danger');
            }
        });
    });

    // ============================
    // Botón "Ver Últimas 7 Ventas"
    // ============================
    $('#btnVerUltimasVentas').on('click', function(){
        // Mostrar modal
        $('#modalUltimasVentas').modal('show');
        // Cargar las últimas 7 ventas
        loadUltimasVentas();
    });

    // ============================
    // Función cargar las últimas 7 ventas
    // ============================
    // Evento click para el botón Facturar SAT
    $(document).on('click', '.facturar-sat', function() {
        const ventaId = $(this).data('id');
        const tipo = $(this).data('tipo');
        window.location.href = `facturasat.php?venta_id=${ventaId}&tipo=${tipo}`;
    });

    function loadUltimasVentas(){
        $.ajax({
            url: 'get_last_sales.php',
            method: 'GET',
            dataType: 'json',
            success: function(response){
                if(response.success){
                    let ventasHtml = '';
                    response.ventas.forEach(venta => {
                        ventasHtml += `
                            <tr>
                                <td>${venta.id}</td>
                                <td>${venta.fecha_y_hora}</td>
                                <td>Q ${venta.total}</td>
                                <td>${venta.tipo}</td>
                                <td>
                                    <button class="btn btn-info btn-sm ver-detalle-venta" data-id="${venta.id}" data-tipo="${venta.tipo}">
                                        Ver Detalle
                                    </button>
                                    <button class="btn btn-warning btn-sm modificar-venta" data-id="${venta.id}" data-tipo="${venta.tipo}">
                                        Modificar
                                    </button>
                                    <button class="btn btn-danger btn-sm eliminar-venta" data-id="${venta.id}" data-tipo="${venta.tipo}">
                                        Eliminar
                                    </button>
                                    <button class="btn btn-secondary btn-sm imprimir-ticket" data-id="${venta.id}">
                                        Imprimir
                                    </button>
                                </td>
                                <td>
                                    <button class="btn btn-primary btn-sm facturar-sat" data-id="${venta.id}" data-tipo="${venta.tipo.toLowerCase()}">
                                        Facturar SAT
                                    </button>
                                </td>
                            </tr>
                            <tr id="detalle-venta-${venta.id}" style="display:none;">
                                <td colspan="6">
                                    <div class="detalle-content p-3"></div>
                                </td>
                            </tr>
                        `;
                    });
                    $('#tablaUltimasVentas tbody').html(ventasHtml);
                } else {
                    $('#tablaUltimasVentas tbody').html('<tr><td colspan="6" class="text-center">No se pudieron cargar las ventas.</td></tr>');
                }
            },
            error: function(){
                $('#tablaUltimasVentas tbody').html('<tr><td colspan="6" class="text-center text-danger">Error de comunicación con el servidor.</td></tr>');
            }
        });
    }

    // ============================
    // Mostrar/Ocultar detalle de venta
    // ============================
    $(document).on('click', '.ver-detalle-venta', function(){
        const ventaId = $(this).data('id');
        const tipo    = $(this).data('tipo');
        const rowDetalle = $('#detalle-venta-' + ventaId);
        const content = rowDetalle.find('.detalle-content');

        // Si ya está visible, lo ocultamos
        if (rowDetalle.is(':visible')) {
            rowDetalle.hide();
            return;
        }

        // Si no está visible, hacemos AJAX para cargar el detalle
        $.ajax({
            url: tipo === 'Normal' ? 'get_detalle_venta.php?format=html' : 'get_detalle_venta_especial.php?format=html',
            method: 'GET',
            data: { venta_id: ventaId },
            dataType: 'html',
            success: function(response) {
                content.html(response);
                rowDetalle.show();
            },
            error: function() {
                content.html('<p style="color:red;">Error al cargar el detalle.</p>');
                rowDetalle.show();
            }
        });
    });

    // ============================
    // Modificar una venta
    // ============================
    $(document).on('click', '.modificar-venta', function(){
        const ventaId = $(this).data('id');
        const tipo    = $(this).data('tipo');

        if(tipo === 'Normal'){
            // Manejo existente para ventas normales
            // Permitir que la venta normal se cargue al carrito para su modificación
            // Aquí se realiza el mismo proceso que anteriormente
            // Obtener los detalles de la venta normal para cargar al carrito
            $.ajax({
                url: 'get_detalle_venta.php?format=json',
                method: 'GET',
                data: { venta_id: ventaId },
                dataType: 'json',
                success: function(response){
                    if(response.success){
                        // Limpiar el carrito
                        cart = [];

                        // Cargar los productos al carrito
                        response.detalle.forEach(item => {
                            cart.push({
                                name: item.NombreComercial,
                                lab: item.laboratorio,
                                price: parseFloat(item.precio),
                                quantity: parseInt(item.cantidad),
                                facturar: item.facturado === '1'
                            });
                        });

                        updateCart();

                        // Guardar el ID de la venta en modificación
                        ventaEnModificacion = ventaId;

                        // Cerrar el modal de últimas ventas
                        $('#modalUltimasVentas').modal('hide');

                        // Mostrar una notificación de éxito
                        showToast('Venta cargada al carrito para su modificación.', 'info');
                    } else {
                        showToast('Error: ' + response.message, 'danger');
                    }
                },
                error: function(){
                    showToast('Error de comunicación con el servidor al cargar la venta.', 'danger');
                }
            });
        }

        if(tipo === 'Especial'){
            // Editar directamente la venta especial desde el modal

            // Realizar una solicitud AJAX para obtener los detalles de la venta especial en formato JSON
            $.ajax({
                url: 'get_detalle_venta_especial.php?format=json',
                method: 'GET',
                data: { venta_id: ventaId },
                dataType: 'json',
                success: function(response){
                    if(response.success){
                        // Llenar el formulario del modal de edición con los datos obtenidos
                        $('#editVentaEspecialId').val(ventaId);
                        $('#editDescripcionEspecial').val(response.detalle.descripcion);
                        $('#editPrecioEspecial').val(response.detalle.precio);

                        // Mostrar el modal de edición
                        $('#modalEditarVentaEspecial').modal('show');
                    } else {
                        showToast('Error: ' + response.message, 'danger');
                    }
                },
                error: function(){
                    showToast('Error de comunicación con el servidor.', 'danger');
                }
            });
        }
    });

    // ============================
    // Botón "Eliminar" de Ventas
    // ============================
    $(document).on('click', '.eliminar-venta', function(){
        const ventaId = $(this).data('id');
        const tipo    = $(this).data('tipo');

        // Llenar el formulario del modal de confirmación con los datos de la venta a eliminar
        $('#eliminarVentaId').val(ventaId);
        $('#eliminarVentaTipo').val(tipo);

        // Mostrar el modal de confirmación
        $('#modalConfirmarEliminar').modal('show');
    });

    // ============================
    // Al enviar el formulario de Confirmación de Eliminación
    // ============================
    $('#formConfirmarEliminar').on('submit', function(e){
        e.preventDefault();

        let ventaId = $('#eliminarVentaId').val();
        let tipo    = $('#eliminarVentaTipo').val();

        $.ajax({
            url: 'delete_sale.php',
            method: 'POST',
            dataType: 'json',
            data: {
                venta_id: ventaId,
                tipo: tipo
            },
            success: function(res){
                if(res.success){
                    // Notificación exitosa
                    showToast('Venta eliminada exitosamente.', 'success');

                    // Cerrar modal de confirmación
                    $('#modalConfirmarEliminar').modal('hide');

                    // Recargar las últimas ventas y los totales del día
                    loadUltimasVentas();
                    loadSalesOfDay();
                } else {
                    // Manejo de errores
                    showToast('Error: ' + res.message, 'danger');
                }
            },
            error: function(){
                // Manejo de errores de comunicación
                showToast('Error de comunicación con el servidor.', 'danger');
            }
        });
    });

    // ============================
    // Al enviar el formulario de edición de Venta Especial
    // ============================
    $('#formEditarVentaEspecial').on('submit', function(e){
        e.preventDefault();

        let ventaId     = $('#editVentaEspecialId').val();
        let descripcion = $('#editDescripcionEspecial').val().trim();
        let precio      = parseFloat($('#editPrecioEspecial').val()) || 0;

        $.ajax({
            url: 'update_special_sale.php',
            method: 'POST',
            dataType: 'json',
            data: {
                venta_id: ventaId,
                descripcion: descripcion,
                precio: precio
            },
            success: function(res){
                if(res.success){
                    // Notificación exitosa
                    showToast('Venta especial actualizada exitosamente.', 'success');

                    // Cerrar modal y resetear formulario
                    $('#modalEditarVentaEspecial').modal('hide');
                    $('#formEditarVentaEspecial')[0].reset();
                    loadUltimasVentas();
                    loadSalesOfDay();
                } else {
                    // Manejo de errores
                    showToast('Error: ' + res.message, 'danger');
                }
            },
            error: function(){
                // Manejo de errores de comunicación
                showToast('Error de comunicación con el servidor.', 'danger');
            }
        });
    });

    // ============================
    // Mostrar totales del día
    // ============================
    function loadSalesOfDay(){
        $.ajax({
            url: 'get_totales_dia.php', // Devuelve total_normal, total_especial, grand_total
            method: 'GET',
            dataType: 'json',
            success: function(res){
                if (res.success) {
                    $('#salesTodayNormal').text(res.total_normal.toFixed(2));
                    $('#salesTodayEspecial').text(res.total_especial.toFixed(2));
                    $('#salesTodayGrand').text(res.grand_total.toFixed(2));
                } else {
                    // En caso de error
                    $('#salesTodayNormal').text('0.00');
                    $('#salesTodayEspecial').text('0.00');
                    $('#salesTodayGrand').text('0.00');
                }
            },
            error: function(){
                $('#salesTodayNormal').text('Err');
                $('#salesTodayEspecial').text('Err');
                $('#salesTodayGrand').text('Err');
            }
        });
    }
    loadSalesOfDay();

    // ============================
    // Mostrar nombre sucursal
    // ============================
    function loadSucursalName(){
        $.ajax({
            url: 'get_sucursal_nombre.php',
            method: 'GET',
            dataType: 'json',
            success: function(res){
                if (res.success) {
                    $('#sucursalName').text(res.nombre_sucursal);
                } else {
                    $('#sucursalName').text('Desconocida');
                }
            },
            error: function(){
                $('#sucursalName').text('Error');
            }
        });
    }
    loadSucursalName();

    // ============================
    // Función para mostrar Toasts de Bootstrap
    // ============================
    function showToast(message, type) {
        // Crear el toast dinámicamente
        const toastId = 'toast-' + Date.now();
        const toastHtml = `
            <div id="${toastId}" class="toast align-items-center text-bg-${type} border-0" role="alert" aria-live="assertive" aria-atomic="true">
              <div class="d-flex">
                <div class="toast-body">
                  ${message}
                </div>
                <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
              </div>
            </div>
        `;
        $('body').append(toastHtml);
        const toastElement = new bootstrap.Toast(document.getElementById(toastId), { delay: 3000 });
        toastElement.show();

        // Eliminar el toast del DOM después de ocultarse
        document.getElementById(toastId).addEventListener('hidden.bs.toast', function () {
            $(this).remove();
        });
    }

});
</script>
</body>
</html>