<?php
include 'conexion.php';
include 'sucursal_config.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $sucursal_origen = $_POST['sucursal_origen'];
    $sucursal_destino = $_POST['sucursal_destino'];
    $observaciones = $_POST['observaciones'];
    $productos = $_POST['productos'];
    $cantidades_unidad = $_POST['cantidad_unidad'];
    $cantidades_blister = $_POST['cantidad_blister'];
    $cantidades_caja = $_POST['cantidad_caja'];

    mysqli_begin_transaction($conexion);

    try {
        // Insert main transfer record
        $query = "INSERT INTO traslados (sucursal_origen, sucursal_destino, observaciones, estado) 
                 VALUES (?, ?, ?, 'pendiente')";
        $stmt = mysqli_prepare($conexion, $query);
        mysqli_stmt_bind_param($stmt, "iis", $sucursal_origen, $sucursal_destino, $observaciones);
        mysqli_stmt_execute($stmt);
        $traslado_id = mysqli_insert_id($conexion);

        // Insert transfer details
        for ($i = 0; $i < count($productos); $i++) {
            if (!empty($productos[$i])) {
                $query = "INSERT INTO detalle_traslados (traslado_id, producto_id, cantidad_unidad, cantidad_blister, cantidad_caja) 
                         VALUES (?, ?, ?, ?, ?)";
                $stmt = mysqli_prepare($conexion, $query);
                mysqli_stmt_bind_param($stmt, "iiiii", 
                    $traslado_id, 
                    $productos[$i], 
                    $cantidades_unidad[$i], 
                    $cantidades_blister[$i], 
                    $cantidades_caja[$i]
                );
                mysqli_stmt_execute($stmt);
            }
        }

        mysqli_commit($conexion);
        echo "success";
    } catch (Exception $e) {
        mysqli_rollback($conexion);
        echo "error";
    }
}